import React from 'react';
import {MDBDropdown, MDBDropdownToggle, MDBDropdownMenu, MDBDropdownItem, MDBIcon} from "mdbreact";
import { useIsAdmin, useIsStaff } from '../../hooks/authTools';

export default function AdminSection (props) {

    const isStaff = useIsStaff();
    const isAdmin = useIsAdmin();

    if (!isStaff) {
        return (
            <MDBDropdown >
                <MDBDropdownToggle nav caret>
                Bonjour {props.user.firstName} &nbsp;
                  <MDBIcon icon="user" />
                </MDBDropdownToggle>
                <MDBDropdownMenu right={Boolean(window.screen.width > 767)} basic className="dropdown-default">
                  <MDBDropdownItem header>Ma course</MDBDropdownItem>
                  <MDBDropdownItem href="/MaCourse" ><MDBIcon icon="address-card" />&nbsp; Mes résultats</MDBDropdownItem>
                  </MDBDropdownMenu>
            </MDBDropdown>)
    }
    else {
        if (!isAdmin) {
            return (
                <MDBDropdown >
                    <MDBDropdownToggle nav caret>
                    Bonjour {props.user.firstName} &nbsp;
                      <MDBIcon icon="user" />
                    </MDBDropdownToggle>
            <MDBDropdownMenu right={Boolean(window.screen.width > 767)} basic className="dropdown-default">
                      <MDBDropdownItem header>Ma course</MDBDropdownItem>
                      <MDBDropdownItem href="/MaCourse" ><MDBIcon icon="address-card" />&nbsp; Mes résultats</MDBDropdownItem>
                      <MDBDropdownItem header>Admin</MDBDropdownItem>
                      <MDBDropdownItem href="/Input" ><MDBIcon icon="plus" />&nbsp; Entrer résultats</MDBDropdownItem>
                      <MDBDropdownItem divider />
                      <MDBDropdownItem href="/api/logout" className="danger-color white-text rounded"><MDBIcon icon="power-off" />&nbsp; Déconnexion</MDBDropdownItem>
            </MDBDropdownMenu>
            </MDBDropdown>
            )
        }
        else {
            return (
                <MDBDropdown >
                    <MDBDropdownToggle nav caret>
                    Bonjour {props.user.firstName} &nbsp;
                      <MDBIcon icon="user" />
                    </MDBDropdownToggle>
            <MDBDropdownMenu right={Boolean(window.screen.width > 767)} basic className="dropdown-default">
                      <MDBDropdownItem header>Ma course</MDBDropdownItem>
                      <MDBDropdownItem href="/MaCourse" ><MDBIcon icon="address-card" />&nbsp; Mes résultats</MDBDropdownItem>
                      <MDBDropdownItem header>Admin</MDBDropdownItem>
                      <MDBDropdownItem href="/Input" ><MDBIcon icon="plus" />&nbsp; Entrer résultats</MDBDropdownItem>
                      <MDBDropdownItem href="/Gestion" ><MDBIcon icon="edit" />&nbsp; Gestion</MDBDropdownItem>
                      <MDBDropdownItem divider />
                      <MDBDropdownItem href="/api/logout" className="danger-color white-text rounded"><MDBIcon icon="power-off" />&nbsp; Déconnexion</MDBDropdownItem>
            </MDBDropdownMenu>
            </MDBDropdown>
            )
        }
    }

}