import React, { useState, useEffect } from "react";
import { MDBRow, MDBCol, MDBInput, MDBBtn, MDBCard, MDBCardBody, MDBModalFooter, MDBIcon, MDBContainer } from 'mdbreact';
import axios from 'axios';
import eventData from "../../eventData/eventData.json";

function Submit(props) {

    const timenow = parseInt(Date.now());
    var realId;
    var realName;

    if (timenow <= eventData.dateFin) {
        realId = props.participant.value;
        realName = props.participant.label
    }
    else {
        realId = 'sprint';
        realName = 'Sprint'
    }


    function addScore() {

        axios.post('/api/staff/new_score',
            {
                score: Math.max(0, props.score),
                equipe: props.equipe.value,
                participant: realId
            })
            .then(() => {
                axios.post('/api/staff/new_participant_with_id',
                    {
                        id: realId,
                        name: realName
                    })
            })
            .then(() => {
                alert("Score ajouté");
                window.location = '/Input';
            }, (error) => {
                console.log(error);
            })
    };








    const onSubmit = () => { addScore() };

    return (
        <MDBBtn type="submit" icon="send" gradient="blue" rounded disabled={props.unlock} className="btn-block z-depth-1a" onClick={onSubmit}><MDBIcon icon="paper-plane" className="ml-1" /> Envoyer</MDBBtn>
    )
}

export default Submit;