import React, { useState, useEffect } from 'react';
import { MDBDataTableV5 } from 'mdbreact';

export default function ListeScores(props) {

  var dataTab = [];
  let liste = props.data;

  if (liste === undefined) {
    liste = [];
  }

  function RefreshData() {
    var i = 1;
    liste.map((item) => 
    dataTab.push(
      {
        rank: i++,
        heure: item.date.split('T')[0]+" - "+item.date.split('T')[1].split('.')[0],
        asso: item.equipe_name,
        tours: item.score
      },
    ),
  );
  return({
    columns: [
      {
        label: '# Session',
        field: 'rank',
        sort: 'disabled',
        width: 100,
      },
      {
        label: 'Heure (GMT)',
        field: 'heure',
        width: 250,
        sort: 'disabled',
        attributes: {
          'aria-controls': 'DataTable',
          'aria-label': 'Association',
        },
      },
      {
        label: 'Association',
        field: 'asso',
        sort: 'disabled',
        width: 100,
      },
      {
        label: 'Tours',
        field: 'tours',
        sort: 'disabled',
        width: 100,
      },
    ],
    rows: dataTab})
  }

  return <MDBDataTableV5 paging={false} hover striped entries={5} entriesOptions={[ 5, 10, 15 ]} info={false}  data={RefreshData()} searchLabel="Rechercher" responsiveLg />;
}