import React,{useState} from "react";
import { MDBRow, MDBCol, MDBInput, MDBBtn, MDBCard, MDBCardBody, MDBModalFooter, MDBIcon, MDBContainer } from 'mdbreact';
import SearchNom from "./Autocomplete/Nom";
import SearchAsso from "./Autocomplete/Association";
import axios from 'axios';
import SubmitButton from "./SubmitForm";
import { useIsStaff } from "../../hooks/authTools";

function Kilometrage () {  

    const smallStyle = { fontSize: '0.8rem'};
    const [nom, setNom] = useState({
        label: "",
        value: ""
    });
    const [asso, setAsso] = useState(
        {
            label: "",
            value: ""
        }
    );
    const [dist, setDist] = useState("");

    function unlock (nameEntry, assoEntry, distanceEntry) {
        var s = new Boolean(true);
        if ((nameEntry != "") && (assoEntry != "") && (distanceEntry != "")) {
            s = false;
        }
        return(s)
    };

    if (!useIsStaff()) {
        return (
        <MDBContainer className="mt-4">
            Accès réservé aux staffeurs ...
            <br /> <br />
        </MDBContainer>
            )
    }

    return (
        <>
        <MDBContainer className="mt-4">
        <MDBRow>
          <MDBCol xs="6" sm="6" md="6" lg="6" xl="6" className="mx-auto mt-3">
            <MDBCard>
              <MDBCardBody className="mx-3">
                <div className="text-center">
                  <h3 className="dark-grey-text mb-5"><strong>Entrer un nombre de tours</strong></h3>
                </div>
                <MDBRow>
                    <MDBCol lg="1" middle size="2">
                        <MDBIcon icon="user-alt" className="mr-1" />
                    </MDBCol>
                    <MDBCol lg="11" size="10">
                        <SearchNom handleChange={(e) => {setNom(e);
    console.log(Date.now());}} />
                    </MDBCol>
                </MDBRow>
                <MDBRow>
                    &nbsp;
                </MDBRow>
                <MDBRow>
                    <MDBCol lg="1" middle size="2">
                        <MDBIcon icon="users" className="mr-1" />
                    </MDBCol>
                    <MDBCol lg="11" size="10">
                        <SearchAsso handleChange={(e) => {setAsso(e)}}/>
                    </MDBCol>
                </MDBRow>
                <MDBRow>
                    &nbsp;
                </MDBRow>
                <MDBRow>
                    <MDBCol lg="1" middle size="2">
                        <div className="form-group">
                        <MDBIcon icon="flag-checkered" className="mr-1" />
                        </div>
                    </MDBCol>
                    <MDBCol lg="11" size="10">
                    <div className="form-group">
                    <input
                        type="number"
                        className="form-control"
                        id="formGroupExampleInput"
                        placeholder="Tour(s) effectué(s)"
                        onChange={(e) => {setDist(parseInt(e.target.value))}}
                    />
                    </div>
                    </MDBCol>
                </MDBRow>
                <div className="text-center pt-3 mb-3">
                  <SubmitButton score={dist} equipe={asso} participant={nom} unlock={unlock(nom.label,asso.label,dist)} />
                </div>
              </MDBCardBody>
            </MDBCard>
          </MDBCol>
        </MDBRow>
        <MDBRow>
            <p> </p>
        </MDBRow>
        </MDBContainer>
        </>
    );
  }

export default Kilometrage;