import React, { useState, useEffect } from 'react';
import axios from 'axios';

export function TableauStaffeursAdmin(){
  var [staffeurs,setStaffeurs] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/admin/staffeurs').then((response) => setStaffeurs(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  return(
    <table className="table">
      <thead className="thead-light">
        <tr>
          <th scope="col">Login</th>
          {/*<th scope="col">Modifier</th>*/}
          <th scope="col">Supprimer</th>
        </tr>
      </thead>
      <tbody>
        {staffeurs.map((item) => {
          var deleteUrl='/admin/staffeurs/delete/'+item.id;
          return (
          <tr key={item.id}>
            <th scope="row">{item.login}</th>
            {/*<td><a className="btn btn-secondary" href={editUrl} role="button">Modifier</a></td>*/}
            <td><a className="btn btn-danger" href={deleteUrl} role="button">Supprimer</a></td>
          </tr>
          )
        })}
      </tbody>
    </table>
  )
}
