import React, { useState, useEffect } from 'react';
import axios from 'axios';

export function TableauScoresAdmin(){
  var [scores,setScores] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/admin/admin_scores').then((response) => setScores(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  return(
    <table className="table">
      <thead className="thead-light">
        <tr>
          <th scope="col">Date</th>
          <th scope="col">Score</th>
          <th scope="col">Participant</th>
          <th scope="col">Equipe</th>
          {/*<th scope="col">Voir</th>*/}
          <th scope="col">Supprimer</th>
        </tr>
      </thead>
      <tbody>
        {scores.map((item) => {
          var viewUrl='/admin/scores/view/'+item.id;
          var deleteUrl='/admin/scores/delete/'+item.id;
          return (
          <tr key={item.id}>
            <th scope="row">{item.date.split('T')[0]} - {item.date.split('T')[1].split('.')[0]}</th>
            <td>{item.score}</td>
            <td>{item.participant}</td>
            <td>{item.equipe}</td>
            {/*<td><a className="btn btn-secondary" href={viewUrl} role="button">Voir</a></td>*/}
            <td><a className="btn btn-danger" href={deleteUrl} role="button">Delete</a></td>
          </tr>
          )
        })}
      </tbody>
    </table>
  )
}
