import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function AfficheScore({ match }){

  const { params: { id } } = match;

  const [scores, setScores] = useState([]);
  useEffect(() => {axios.get('/api/admin/admin_scores').then((response) => setScores(response.data))}, []);
  const [currentScore, setCurrentScore] = useState({});
  useEffect(() => {
    scores.map(item => {
      if (item.id==id) {setCurrentScore(item)}
      return null;
    })
  });

  var editScoreUrl='/admin/scores/edit/score/'+id;
  var editEquipeUrl='/admin/scores/edit/equipe/'+id;
  var editParticipantUrl='/admin/scores/edit/participant/'+id;
  return(
    <div>
      <h1>Modification du score</h1>
      <a className="btn btn-secondary" href="/admin/scores" role="button">Retour</a>
      <table className="table">
        <thead className="thead-light">
          <tr>
            <th scope="col">Champ</th>
            <th scope="col">Valeur</th>
            <th scope="col">Action</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <th scope="row">Score</th>
            <td>{currentScore.score}</td>
            <td><a className="btn btn-secondary" href={editScoreUrl} role="button">Modifier</a></td>
          </tr>
          <tr>
            <th scope="row">Equipe</th>
            <td>{currentScore.equipe}</td>
            <td><a className="btn btn-secondary" href={editEquipeUrl} role="button">Modifier</a></td>
          </tr>
          <tr>
            <th scope="row">Participant</th>
            <td>{currentScore.participant}</td>
            <td><a className="btn btn-secondary" href={editParticipantUrl} role="button">Modifier</a></td>
          </tr>
        </tbody>
      </table>
    </div>
  )
}

export function UpdateScoreScore({ match }){

  const { params: { id } } = match;

  const editScore = (props) => {
    axios.post('/api/admin/update_score/score',{id: props.id, score:props.score})
    .then(() => {
      alert('Score mis à jour');
      window.location='/admin/scores/view/'+id;
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editScore({id:id,score:data.score})}

  const returnUrl = "/admin/scores/view/"+id;

  return(
    <div>
      <a className="btn btn-secondary" href={returnUrl} role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="scoreInput">Score</label>
          <input type="number" className="form-control" id="scoreInput" name="score" ref={register}/>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )

}

export function UpdateScoreEquipe({ match }){

  const { params: { id } } = match;

  const editEquipe = (props) => {
    axios.post('/api/admin/update_score/equipe',{id: id, equipe:props.equipe})
    .then(() => {
      alert('Score mis à jour');
      window.location='/admin/scores/view/'+id;
    }, (error) => {
      console.log(error);
    });
  };

  const [equipes,setEquipes] = useState([]);
  useEffect(() => {axios.get('/api/equipes').then((response) => setEquipes(response.data))}, []);

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editEquipe(data)}

  const returnUrl = "/admin/scores/view/"+id;

  return(
    <div>
      <a className="btn btn-secondary" href={returnUrl} role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="equipeInput">Equipe</label>
          <select className="form-control" id="equipeInput" name="equipe" ref={register}>
            {equipes.map(item => (<option key={item.id} value={item.id}>{item.name}</option>))}
          </select>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )

}

export function UpdateScoreParticipant({ match }){

  const { params: { id } } = match;

  const editParticipant = (props) => {
    axios.post('/api/admin/update_score/participant',{id: id, participant:props.participant})
    .then(() => {
      alert('Score mis à jour');
      window.location='/admin/scores/view/'+id;
    }, (error) => {
      console.log(error);
    });
  };

  const [participants,setParticipants] = useState([]);
  useEffect(() => {axios.get('/api/participants').then((response) => setParticipants(response.data))}, []);

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editParticipant(data)}

  const returnUrl = "/admin/scores/view/"+id;

  return(
    <div>
      <a className="btn btn-secondary" href={returnUrl} role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="participantInput">Equipe</label>
          <select className="form-control" id="participantInput" name="participant" ref={register}>
            {participants.map(item => (<option key={item.id} value={item.id}>{item.name}</option>))}
          </select>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )

}
