import React, { useState, useEffect } from 'react';
import axios from 'axios';

export function TableauParticipantsAdmin(){
  var [participants,setParticipants] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/participants').then((response) => setParticipants(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  return(
    <table className="table">
      <thead className="thead-light">
        <tr>
          <th scope="col">Login</th>
          <th scope="col">Participant</th>
          {/*<th scope="col">Modifier</th>*/}
          <th scope="col">Supprimer</th>
        </tr>
      </thead>
      <tbody>
        {participants.map((item) => {
          var editUrl='/admin/participants/edit/'+item.id;
          var deleteUrl='/admin/participants/delete/'+item.id;
          return (
          <tr key={item.id}>
            <th scope="row">{item.id}</th>
            <th scope="row">{item.name}</th>
            {/*<td><a className="btn btn-secondary" href={editUrl} role="button">Modifier</a></td>*/}
            <td><a className="btn btn-danger" href={deleteUrl} role="button">Supprimer</a></td>
          </tr>
          )
        })}
      </tbody>
    </table>
  )
}
