import React from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function AddParticipantForm(){

  const addParticipant = (props) => {
    axios.post('/api/admin/new_participant',
    {
        name: props.name
    })
    .then(() => {
      alert("Participant ajouté");
      window.location='/admin/participants';
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {addParticipant(data)}
  return(
  <div>
    <a className="btn btn-secondary" href="/admin/participants" role="button">Retour</a>
    <form onSubmit={handleSubmit(onSubmit)}>
      <div className="form-group">
        <label htmlFor="nameInput">Nom</label>
        <input type="text" className="form-control" id="nameInput" name="name" ref={register} placeholder="Gérard" required/>
      </div>
      <button type="submit" className="btn btn-secondary">Ajouter</button>
    </form>
  </div>
  )
}
