import React, { useState, useEffect } from 'react';
import axios from 'axios';

export function TableauObjectifsAdmin(){
  var [objectifs,setObjectifs] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/admin/admin_objectifs').then((response) => setObjectifs(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  return(
    <table className="table">
      <thead className="thead-light">
        <tr>
          <th scope="col">Nom</th>
          <th scope="col">Description</th>
          <th scope="col">Objectif</th>
          <th scope="col">Coefficient</th>
          <th scope="col">Voir</th>
          <th scope="col">Supprimer</th>
        </tr>
      </thead>
      <tbody>
        {objectifs.map((item) => {
          var viewUrl='/admin/objectifs/view/'+item.id;
          var deleteUrl='/admin/objectifs/delete/'+item.id;
          return (
          <tr key={item.id}>
            <th scope="row">{item.name}</th>
            <td>{item.description}</td>
            <td>{item.value}</td>
            <td>{item.coef}</td>
            <td><a className="btn btn-secondary" href={viewUrl} role="button">Voir</a></td>
            <td><a className="btn btn-danger" href={deleteUrl} role="button">Delete</a></td>
          </tr>
          )
        })}
      </tbody>
    </table>
  )
}
