import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function AfficheObjectif({ match }){

  const { params: { id } } = match;

  const [objectifs, setObjectifs] = useState([]);
  useEffect(() => {axios.get('/api/admin/admin_objectifs').then((response) => setObjectifs(response.data))}, []);
  const [currentObjectif, setCurrentObjectif] = useState({});
  useEffect(() => {
    objectifs.map(item => {
      if (item.id==id) {setCurrentObjectif(item)}
      return null;
    })
  });

  var editNameUrl='/admin/objectifs/edit/name/'+id;
  var editDescriptionUrl='/admin/objectifs/edit/description/'+id;
  var editValueUrl='/admin/objectifs/edit/value/'+id;
  var editCoefUrl='/admin/objectifs/edit/coef/'+id;
  return(
    <div>
      <h1>Modification objectif</h1>
      <a className="btn btn-secondary" href="/admin/objectifs" role="button">Retour</a>
      <table className="table">
        <thead className="thead-light">
          <tr>
            <th scope="col">Champ</th>
            <th scope="col">Valeur</th>
            <th scope="col">Action</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <th scope="row">Nom</th>
            <td>{currentObjectif.name}</td>
            <td><a className="btn btn-secondary" href={editNameUrl} role="button">Modifier</a></td>
          </tr>
          <tr>
            <th scope="row">Description</th>
            <td>{currentObjectif.description}</td>
            <td><a className="btn btn-secondary" href={editDescriptionUrl} role="button">Modifier</a></td>
          </tr>
          <tr>
            <th scope="row">Objectif</th>
            <td>{currentObjectif.value}</td>
            <td><a className="btn btn-secondary" href={editValueUrl} role="button">Modifier</a></td>
          </tr>
          <tr>
            <th scope="row">Coefficient</th>
            <td>{currentObjectif.coef}</td>
            <td><a className="btn btn-secondary" href={editCoefUrl} role="button">Modifier</a></td>
          </tr>
        </tbody>
      </table>
    </div>
  )
}

export function UpdateObjectifName({ match }){

  const { params: { id } } = match;

  const editName = (props) => {
    axios.post('/api/admin/update_objectif/name',{id: props.id, name:props.name})
    .then(() => {
      alert('Nom mis à jour');
      window.location='/admin/objectifs/view/'+id;
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editName({id:id,name:data.name})}

  const returnUrl = "/admin/objectifs/view/"+id;

  return(
    <div>
      <a className="btn btn-secondary" href={returnUrl} role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="nameInput">Nom</label>
          <input type="text" className="form-control" id="nameInput" name="name" ref={register}/>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )
}

export function UpdateObjectifDescription({ match }){

  const { params: { id } } = match;

  const editDescription = (props) => {
    axios.post('/api/admin/update_objectif/description',{id: props.id, description:props.description})
    .then(() => {
      alert('Description mise à jour');
      window.location='/admin/objectifs/view/'+id;
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editDescription({id:id,description:data.description})}

  const returnUrl = "/admin/objectifs/view/"+id;

  return(
    <div>
      <a className="btn btn-secondary" href={returnUrl} role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div clasNames="form-group">
          <label htmlFor="descriptionInput">Description</label>
          <textarea className="form-control" id="descriptionInput" rows="3" name="description" ref={register}></textarea>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )
}

export function UpdateObjectifValue({ match }){

  const { params: { id } } = match;

  const editValue = (props) => {
    axios.post('/api/admin/update_objectif/value',{id: props.id, value:props.value})
    .then(() => {
      alert('Objectif mis à jour');
      window.location='/admin/objectifs/view/'+id;
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editValue({id:id,value:data.value})}

  const returnUrl = "/admin/objectifs/view/"+id;

  return(
    <div>
      <a className="btn btn-secondary" href={returnUrl} role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="valueInput">Objectif</label>
          <input type="number" className="form-control" id="valueInput" name="value" ref={register}/>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )
}

export function UpdateObjectifCoef({ match }){

  const { params: { id } } = match;

  const editCoef = (props) => {
    axios.post('/api/admin/update_objectif/coef',{id: props.id, coef:props.coef})
    .then(() => {
      alert('Coefficient mis à jour');
      window.location='/admin/objectifs/view/'+id;
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editCoef({id:id,coef:data.coef})}

  const returnUrl = "/admin/objectifs/view/"+id;

  return(
    <div>
      <a className="btn btn-secondary" href={returnUrl} role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="coefInput">Coefficient (utiliser un point et non pas une virgule)</label>
          <input className="form-control" id="coefInput" name="coef" ref={register}/>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )
}
