import React from 'react';
import axios from 'axios';
import { useForm } from 'react-hook-form';

export function UpdateAdministrateur({ match }){

  const { params: { id } } = match;

  const editAdministrateur = (props) => {
    axios.post('/api/admin/update_administrateur',{id: props.id, login:props.login})
    .then(() => {
      alert('Administrateur mis à jour');
      window.location='/Gestion'
    }, (error) => {
      console.log(error);
    });
  };

  const { register, handleSubmit } = useForm();
  const onSubmit = data => {editAdministrateur({id:id,login:data.login})}

  return(
    <div>
      <a className="btn btn-secondary" href="/Gestion" role="button">Retour</a>
      <form onSubmit={handleSubmit(onSubmit)}>
        <div className="form-group">
          <label htmlFor="loginInput">Login</label>
          <input type="text" className="form-control" id="loginInput" name="login" ref={register}/>
        </div>
        <button type="submit" className="btn btn-secondary">Modifier</button>
      </form>
    </div>
  )

}
