import React from 'react';
import { TableauEvenementsAdmin } from './gestionEvenements/TableauEvenementsAdmin';
import { useIsAdmin } from '../../../hooks/authTools';

const GestionEvenements = function(){

  if (useIsAdmin() === false){
    return <div>Oups, accès réservé aux administrateurs...</div>
  }

  return (
    <div className="container">
      <div className="row">
        <div className="col">
          <h1>Gestion des évenements</h1>
        </div>
        <div className="col-4">
        </div>
        <div className="col">
          <a className="btn btn-secondary" href="/admin/evenements/nouveau" role="button">Saisie nouvel objectif</a>
        </div>
      </div>
      <div className="row">
        <div className="col">
          <TableauEvenementsAdmin />
        </div>
      </div>
    </div>
)}

export default GestionEvenements;
