import React, { useState, useEffect, Component } from 'react';
import axios from 'axios';
import GestionAdministrateurs from "./Gestion/GestionAdministrateurs";
import GestionEquipes from "./Gestion/GestionEquipes";
import GestionParticipants from "./Gestion/GestionParticipants";
import GestionScore from "./Gestion/GestionScore";
import GestionStaffeurs from "./Gestion/GestionStaffeurs";


import { MDBContainer, MDBRow, MDBCol, MDBTabPane, MDBTabContent, MDBNav, MDBNavItem, MDBNavLink, MDBIcon } from "mdbreact";

class Pills extends Component {
  state = {
    items: {
      default: "1",
    }
  };

  togglePills = (type, tab) => e => {
    e.preventDefault();
    if (this.state.items[type] !== tab) {
      let items = { ...this.state.items };
      items[type] = tab;
      this.setState({
        items
      });
    }
  };

  render() { 
    
    return (
      <MDBContainer className="mt-4">
          <MDBRow>
            <MDBCol md="12">
              <h2><MDBIcon icon="edit" className="mr-1" /> Gestion</h2>
              <MDBNav className="mt-5 nav-pills">
                <MDBNavItem>
                  <MDBNavLink link to="#" active={this.state.items["default"] === "1"} onClick={this.togglePills("default", "1")} >
                  <MDBIcon icon="tools" className="mr-1" /> Administrateurs
                  </MDBNavLink>
                </MDBNavItem>
                <MDBNavItem>
                  <MDBNavLink link to="#" active={this.state.items["default"] === "2"} onClick={this.togglePills("default", "2")} >
                  <MDBIcon icon="users" className="mr-1" /> Associations
                  </MDBNavLink>
                </MDBNavItem>
                <MDBNavItem>
                  <MDBNavLink link to="#" active={this.state.items["default"] === "5"} onClick={this.togglePills("default", "5")} >
                  <MDBIcon icon="address-book" className="mr-1" /> Participants
                  </MDBNavLink>
                </MDBNavItem>
                <MDBNavItem>
                  <MDBNavLink link to="#" active={this.state.items["default"] === "6"} onClick={this.togglePills("default", "6")} >
                  <MDBIcon icon="chart-line" className="mr-1" /> Scores
                  </MDBNavLink>
                </MDBNavItem>
                <MDBNavItem>
                  <MDBNavLink link to="#" active={this.state.items["default"] === "7"} onClick={this.togglePills("default", "7")} >
                  <MDBIcon icon="user-edit" className="mr-1" /> Staffeurs
                  </MDBNavLink>
                </MDBNavItem>
                </MDBNav>
              <MDBTabContent activeItem={this.state.items["default"]}>
                <MDBTabPane tabId="1">
                  <GestionAdministrateurs />
                </MDBTabPane>
                <MDBTabPane tabId="2">
                  <GestionEquipes />
                </MDBTabPane>
                <MDBTabPane tabId="5">
                  <GestionParticipants />
                </MDBTabPane>
                <MDBTabPane tabId="6">
                  <GestionScore />
                </MDBTabPane>
                <MDBTabPane tabId="7">
                  <GestionStaffeurs />
                </MDBTabPane>
              </MDBTabContent>
            </MDBCol>
          </MDBRow>
          <MDBRow>
            <p> </p>
          </MDBRow>
        </MDBContainer>
      );
    }
}

export default Pills;