import React from 'react';

import Select from 'react-select';
import AsyncSelect from 'react-select/async';
import { useState } from 'react';

/*const nameOptions = [
    { value: 'Action', label: 'Action' },
    { value: 'Adventure', label: 'Adventure' },
    { value: 'Children', label: 'Children' },
    { value: 'Comedy', label: 'Comedy' },
    { value: 'Crime', label: 'Crime' },
    { value: 'Drama', label: 'Drama' },
    { value: 'Fantastic', label: 'Fantastic' },
    { value: 'Fantasy', label: 'Fantasy' },
    { value: 'Heroes', label: 'Heroes' },
    { value: 'Horror', label: 'Horror' },
    { value: 'Musical', label: 'Musical' },
    { value: 'Polar', label: 'Polar' },
    {value: 'Romance', label: 'Romance' },
    { value: 'Sci-Fi', label: 'Sci-Fi' },
    { value: 'Thriller', label: 'Thriller' },
    { value: 'Violence', label: 'Violence' },
    { value: 'Western', label: 'Western' }
    ]*/

var nameOptions = []

const groupStyles = {
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'space-between',
};
const groupBadgeStyles = {
  backgroundColor: '#EBECF0',
  borderRadius: '2em',
  color: '#172B4D',
  display: 'inline-block',
  fontSize: 12,
  fontWeight: 'normal',
  lineHeight: '1',
  minWidth: 1,
  padding: '0.16666666666667em 0.5em',
  textAlign: 'center',
};

const formatGroupLabel = data => (
  <div style={groupStyles}>
    <span>{data.label}</span>
    <span style={groupBadgeStyles}>{data.options.length}</span>
  </div>
);

const SearchNom = (props) => {
  return (<AsyncSelect
    placeholder="Nom"
    formatGroupLabel={formatGroupLabel}
    name="Nom"
    onChange={props.handleChange}
    defaultOptions={true}
    loadOptions={async (e) => {
      let users = [];
      await fetch(`/api/staff/get_user?userString=${encodeURIComponent(e)}`).then(
        async (resp) => {
          console.log("sent " + e)
          users = await resp.json()
        }
      ).catch(e => console.log("Triste" + e.message));
      var auxOptions = [];
      users.map(d => auxOptions.push({ value: d.login, label: d.firstName + " " + d.lastName }));
      return (auxOptions);
    }}
    maxMenuHeight={175}
  />)
};

export default SearchNom;
