import React, { Component } from "react";
import { MDBContainer, MDBRow, MDBCol, MDBTabPane, MDBTabContent, MDBNav, MDBNavItem, MDBNavLink, MDBIcon } from "mdbreact";
import ClassIndiv from '../ClassementIndividuel';
import ClassEquipe from '../ClassementEquipe';

class Classement extends Component {
  state = {
    items: {
      default: "1",
    }
  };

  togglePills = (type, tab) => e => {
    e.preventDefault();
    if (this.state.items[type] !== tab) {
      let items = { ...this.state.items };
      items[type] = tab;
      this.setState({
        items
      });
    }
  };

  render() {
    return (
      <MDBContainer className="mt-4">
          <MDBRow>
            <MDBCol md="12">
              <MDBNav className="mt-5 nav-pills">
                <MDBNavItem>
                  <MDBNavLink link to="#" active={this.state.items["default"] === "1"} onClick={this.togglePills("default", "1")} >
                  <MDBIcon icon="user-alt" className="mr-1" /> Individuel
                  </MDBNavLink>
                </MDBNavItem>
                <MDBNavItem>
                  <MDBNavLink link to="#" active={this.state.items["default"] === "2"} onClick={this.togglePills("default", "2")} >
                  <MDBIcon icon="users" className="mr-1" /> Associations
                  </MDBNavLink>
                </MDBNavItem>
              </MDBNav>
              <MDBRow>
                &nbsp;
              </MDBRow>
              <MDBTabContent activeItem={this.state.items["default"]}>
                <MDBTabPane tabId="1">
                  <ClassIndiv />
                </MDBTabPane>
                <MDBTabPane tabId="2">
                  <ClassEquipe />
                </MDBTabPane>
              </MDBTabContent>
            </MDBCol>
          </MDBRow>
        </MDBContainer>
      );
    }
}

export default Classement;