import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { MDBProgress, MDBRow, MDBCol, MDBIcon } from 'mdbreact';
import eventData from "../../eventData/eventData.json";


const ProgressBarPage = () => {

  var [distanceTotale,setDistanceTotale] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/distance_totale').then((response) => setDistanceTotale(response.data[0].distanceTotale));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  function SizeBar (Width) {
    var result = "";
    if (Width > 767) {
      result = "11";
    }
    else {
      result = "10";
    }
    return(result);
  }

  function SizeIcon (Width) {
    var result = "";
    if (Width > 767) {
      result = "1";
    }
    else {
      result = "2";
    }
    return(result);
  }

 function IconSize (Width) {
    var result = "";
    if (Width > 767) {
      result = "2x";
    }
    else {
      result = "1x";
    }
    return(result);
  }  

  return (
    <>
    <MDBRow>
      <MDBCol size={SizeBar(window.screen.width)}>
      <MDBProgress value={distanceTotale*eventData.argentParTour} className="my-2" color="indigo" striped animated max={eventData.plafondArgent} height={"25px"} wrapperStyle={{width: "100%"}}>
          
      </MDBProgress>    
      </MDBCol>
      <MDBCol middle size={SizeIcon(window.screen.width)}>
        <MDBIcon icon="flag-checkered" className="mr-1" size={IconSize(window.screen.width)} />
      </MDBCol>
      </MDBRow>
    </>
  );
}

export default ProgressBarPage;