import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { MDBTable, MDBTableBody, MDBTableHead } from 'mdbreact';

const BasicTable = () => {

  var [equipes, setEquipes] = useState([]);
  useEffect(() => {
    const interval = setInterval(() => {
      axios.get('/api/classement_par_equipes').then((response) => setEquipes(response.data));
    }, 500);
    return () => clearInterval(interval);
  }, []);

  var i = 1;

  const size = 10;

  return (
    <MDBTable small hover bordered responsiveLg>
      <MDBTableHead color="blue-gradient" textWhite>
        <tr>
          <th>#</th>
          <th>Association</th>
          <th>Tours</th>
          <th>Participants</th>
        </tr>
      </MDBTableHead>
      <MDBTableBody>
        {equipes.slice(0,size).map((item) =>
          <tr id={item.id}>
            <td>{i++}</td>
            <td>{item.name}</td>
            <td>{item.score}</td>
            <td>{item.nbParticipant}</td>
          </tr>
        )}
      </MDBTableBody>
    </MDBTable>
  );
}

export default BasicTable;
