var mongoose = require("mongoose");

var Schema = mongoose.Schema;

/**
 * Indique ce que l'on doit trouver dans un toucan
 */
var toucanSchema = new Schema ({
    toucan_id: {type: String, required: true},
    title: {type : String, required: true}, // Chaque toucan doit avoir un titre et une date
    date: {type : Date, required: true}
});

// La date doit être unique
toucanSchema.index({date:-1},{unique: true});

var toucans = mongoose.model("Toucan",toucanSchema);
await toucans.updateMany( {},{$set: { toucan_id : 'example'} }, { multi: true });

module.exports = toucans;