var { Joi } = require("celebrate");

var newToucan = Joi.object({
    title: Joi.string()
        .regex(/^[a-zA-Z0-9áàâäãåçéèêëíìîïñóòôöõúùûüýÿæœÁÀÂÄÃÅÇÉÈÊËÍÌÎÏÑÓÒÔÖÕÚÙÛÜÝŸÆŒ._\s'-]{1,60}$/) //Autorise la plupart des acents
        .required(),
    date: Joi.date().required()
});


var validTitle = Joi.object({
    title: Joi.string()
        .regex(/^[a-zA-Z0-9áàâäãåçéèêëíìîïñóòôöõúùûüýÿæœÁÀÂÄÃÅÇÉÈÊËÍÌÎÏÑÓÒÔÖÕÚÙÛÜÝŸÆŒ._\s'-]{1,60}$/) //Autorise la plupart des acents
        .required(),
});

var validId = Joi.object({id: Joi.string().hex().length(24).required()});

var validGet = Joi.object({
    limit: Joi.number().integer(),
    before: Joi.date().timestamp(),
    after: Joi.date().timestamp()
});

var validURL = Joi.object({
    urlID: Joi.string()
        .regex(/^[a-z0-9áàâäãåçéèêëíìîïñóòôöõúùûüýÿæœ._'-]{1,60}\d{4}$/) //
        .required()
        });

module.exports = { newToucan, validTitle, validId, validURL, validGet };